package gov.va.genisis2.util;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class HelperUtils {
	final static   char[] metaCharacters = { '!', '#', '@', '%', ':', ';', '\'', '=', '\\', '^', '$', '{', '}', '[', ']', '(', ')', '.', '*', '+', '?', '|', '<', '>', '-', '&' };
	private HelperUtils() {
	}
	
	
	public static String escapeMetaCharacters(String inputString) {
		StringBuilder builder = new StringBuilder();
		for (int i = 0, n = inputString.length(); i < n; i++) {
			char c = inputString.charAt(i);
			if (ArrayUtils.contains(metaCharacters, c)) {
				builder = builder.append("\\").append(c);
			} else {
				builder = builder.append(c);
			}
		}
		return builder.toString();
	}
	
}
